
#include "enemy.h"
#include "inputKeyboard.h"
#include "camera.h"
#include "renderer.h"
#include "manager.h"
#include "modeTitle.h"
#include "modeGame.h"
#include "debugStr.h"
#include "modelManager.h"
#include "texManager.h"
#include "sceneField.h"
#include "player.h"
#include "car.h"

//=============================================================================
// CEnemy::
//=============================================================================
void CEnemy::Init(void)
{
	// eNX̏
	CSceneModel::Init();

	m_move = D3DXVECTOR3(0.f, 0.f, 0.f);		// ړ
}

//=============================================================================
// CEnemy::XV
//=============================================================================
void CEnemy::Update(void)
{
	// eNX̍XV
	CSceneModel::Update();

	// L[{[h̎擾
	CInputKeyboard keyboard = CManager::GetKeyboard();
	CCamera *pCamera = CManager::GetCamera();

	D3DXVECTOR3 vec = GetPos() - pCamera->GetPos();	// JvC[ւ̃xNg
	D3DXVECTOR3 rot = GetRot();						// vC[̌
	const float MOVE_SPEED = 5.f;					// ő呬x

	// X,Zʏ̕sړ
	D3DXVECTOR3 moveAt = D3DXVECTOR3(0.f, 0.f, 0.f);
	if (std::rand() % 200 == 0)
	{
		float radX = ((std::rand() % 720) * 0.01f);
		float radY = ((std::rand() % 720) * 0.01f);
		moveAt = D3DXVECTOR3(cosf(radX) * MOVE_SPEED, 0.f, sinf(radY) * MOVE_SPEED);
		m_move += moveAt;
	}

	int LorR = RightorLeft(D3DXVECTOR2(0.f, 0.f), D3DXVECTOR2(sin(rot.y), cos(rot.y)), D3DXVECTOR2(moveAt.x, moveAt.z));
	if (LorR == 1) {
		AddRot(D3DXVECTOR3(0.f, D3DX_PI * 0.02f, 0.f));
	}
	else if (LorR == 2) {
		AddRot(D3DXVECTOR3(0.f, D3DX_PI * -0.02f, 0.f));
	}

	if (std::rand() % 180 == 0)
	{// JUMP
		moveAt = D3DXVECTOR3(0.f, ENEMY_JUMP_SPEED, 0.f);
		m_move += moveAt;
		m_jump = true;
	}

	m_move.x *= m_frictional;	// C
	m_move.z *= m_frictional;	// C
	m_move.y -= 0.1f;			// III

	// ړʂ̉Z
	AddPos(m_move);

	// Փ˔
	for (int n = 0; n < MAX_SCENE_PRIORITY; n++)
	{
		std::list<CScene*> *lisScene = CScene::GetScene(n);
		for (CScene* pScene : *lisScene)
		{
			if (pScene == nullptr)continue;
			// ^Cv̎擾
			CScene::OBJTYPE objType = pScene->GetObjType();

			// tB[h̏ꍇ
			if (objType == CScene::OBJTYPE::FIELD)
			{
				// _ELXg
				CSceneField *pField = ((CSceneField*)pScene);
				D3DXVECTOR3 enemyPos = GetPos();
				float fieldy = pField->GetHeight(enemyPos, nullptr);
				if (enemyPos.y < fieldy)
				{
					SetPos(D3DXVECTOR3(enemyPos.x, fieldy, enemyPos.z));
					m_move.y = 0.f;
					m_jump = false;
				}
				continue;
			}
			// vC[̏ꍇ
			if (objType == CScene::OBJTYPE::PLAYER)
			{
				// _ELXg
				CMainController *pPlayer = ((CMainController*)pScene);
				CCar *pPlayerCar = CCar::GetCar(pPlayer->GetName());
				D3DXVECTOR3 enemyPos = GetPos();
				D3DXVECTOR3 playerPos = pPlayerCar->GetPos();
				// Փ˂Ă
				if ((enemyPos.x - playerPos.x) * (enemyPos.x - playerPos.x) +
					(enemyPos.y - playerPos.y) * (enemyPos.y - playerPos.y) +
					(enemyPos.z - playerPos.z) * (enemyPos.z - playerPos.z) <= (5 + 5) * (5 + 5))
				{
					m_move.y += 1;
					m_jump = true;

					// _[W̍Đ
//					PlaySound(SE_UT_DAMAGE);	// _[W
				}
				continue;
			}
		}
	}
}
int CEnemy::RightorLeft(D3DXVECTOR2 Vec1, D3DXVECTOR2 Vec2, D3DXVECTOR2 pos)
{
	float closs = ((Vec2.x - Vec1.x) * (pos.y - Vec1.y) - (pos.x - Vec1.x) * (Vec2.y - Vec1.y));
	if (closs > 0.f)return 1;
	else if (closs < -0.f)return 2;
	return 0;
}

//=============================================================================
// CEnemy::I
//=============================================================================
void CEnemy::Uninit(void)
{
	// eNX̏I
	CSceneModel::Uninit();
}

//=============================================================================
// CEnemy::`揈
//=============================================================================
void CEnemy::Draw(void)
{
	// eNX̕`
	CSceneModel::Draw();
}

// -------- -------- -------- -------- -------- -------- -------- --------
// 쐬
// -------- -------- -------- -------- -------- -------- -------- --------
CEnemy *CEnemy::Create(const D3DXVECTOR3 &pos, const D3DXVECTOR3 &rotY, const D3DXVECTOR3 &scl, const std::string &strFilePass)
{
	// CScene3D̐
	CEnemy *pPlayer = new CEnemy();
	pPlayer->Init();

	pPlayer->SetPos(pos);
	pPlayer->SetRot(rotY);
	pPlayer->SetScl(scl);
	pPlayer->SetFilePass(strFilePass);

	//---------------------
	// f̃Zbg
	//---------------------
	CManager::GetModelManager()->SetModel(strFilePass);

	//---------------------
	// eNX`̃Zbg
	//---------------------
	D3DXMATERIAL* pMat = CManager::GetModelManager()->GetModelMat(strFilePass);
	for (int nCntMat = 0; nCntMat < (int)CManager::GetModelManager()->GetModelNumMat(strFilePass); nCntMat++)
	{
		// gpĂeNX`Γǂݍ
		if (pMat[nCntMat].pTextureFilename != nullptr && lstrlen(pMat[nCntMat].pTextureFilename) > 0)
		{
			CManager::GetTexManager()->SetTex(pMat[nCntMat].pTextureFilename);
		}
		else { pMat[nCntMat].pTextureFilename = nullptr; }
	}

	return pPlayer;
}